<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <button class="btn btn-primary float-right " data-toggle="modal" data-target="#tambah"><i
                                class="fa fa-plus-circle mr-2"></i> Karyawan
                            Baru</button>
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">

                        <table class="table table-bordered table-hover myTable tab ">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Lengkap</th>
                                    <th>Telp-</th>
                                    <th>Jns. Kelamin</th>
                                    <th>Alamat</th>
                                    <th>Tgl. Input</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($karyawan as $k)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td>{{ $k->nm_karyawan }}</td>
                                        <td>{{ $k->hp_karyawan }}</td>
                                        <td>{{ $k->kelamin_karyawan == 'L' ? 'Laki-Laki' : 'Perempuan' }}</td>
                                        <td>{{ $k->alamat_karyawan }}</td>
                                        <td>{{ tgl_inf($k->created_at) }} </td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm mb-0 mt-0 edit"
                                                data-id="{{ $k->id }}" data-toggle="modal"
                                                data-target="#edit{{ $k->id }}">
                                                <i class="fa fa-edit mr-2"></i> Edit
                                            </button>
                                            <button class="btn btn-danger btn-sm mb-0 mt-0 hapus"
                                                data-id="{{ $k->id }}" data-nm="{{ $k->nm_karyawan }}">
                                                <i class="fa fa-trash mr-1"></i> Hapus
                                            </button>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="20">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>

    <div class="modal fade" id="tambah">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    Tambah Karyawan Baru
                </div>
                <form action="{{ route('karyawan.store') }}" method="post">
                    @csrf
                    <div class="modal-body">

                        <div class="form-group">
                            <label>Nama Lengkap</label>
                            <input type="text" name="nm_karyawan" class="form-control" placeholder="Nama Lengkap"
                                autofocus required value="{{ old('nm_karyawan') }}">
                            @error('nm_karyawan')
                                <small class="text-danger mt-2">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>No Hp</label>
                            <input type="text" name="hp_karyawan" class="form-control" placeholder="Telp-" required
                                value="{{ old('hp_karyawan') }}">
                            @error('hp_karyawan')
                                <small class="text-danger mt-2">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Jenis Kelamin</label>
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="custom-control custom-radio">
                                        <input class="custom-control-input" type="radio" id="laki" value="L"
                                            name="kelamin_karyawan" checked
                                            {{ old('jns_kelamin') == 'L' ? 'checked' : '' }}>
                                        <label for="laki" class="custom-control-label ">Laki-Laki
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="custom-control custom-radio">
                                        <input class="custom-control-input" type="radio" id="perempuan" value="P"
                                            name="kelamin_karyawan" {{ old('jns_kelamin') == 'P' ? 'checked' : '' }}>
                                        <label for="perempuan" class="custom-control-label ">Perempuan
                                        </label>
                                    </div>
                                </div>
                            </div>
                            @error('kelamin_karyawan')
                                <small class="text-danger mt-2">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Alamat Lengkap</label>
                            <textarea name="alamat_karyawan" id="" class="form-control" placeholder="Alamat....">{{ old('alamat_karyawan') }}</textarea>
                            @error('alamat_karyawan')
                                <small class="text-danger mt-2">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>

                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary "><i class="fa fa-save"></i> Simpan</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    @foreach ($karyawan as $k)
        <div class="modal fade" id="edit{{ $k->id }}">
            <div class="modal-dialog ">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        Edit Karyawan Baru
                    </div>
                    <form action="{{ route('karyawan.update') }}" method="post">
                        @csrf
                        @method('put')
                        <div class="modal-body">
                            <input type="hidden" name="id" id="" value="{{ $k->id }}">
                            <input type="hidden" name="hplama" id="" value="{{ $k->hp_karyawan }}">
                            <div class="form-group">
                                <label>Nama Lengkap</label>
                                <input type="text" name="nm_karyawan" class="form-control"
                                    placeholder="Nama Lengkap" autofocus required value="{{ $k->nm_karyawan }}">
                                @error('nm_karyawan')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>No Hp</label>
                                <input type="text" name="hp_karyawan" class="form-control" placeholder="Telp-"
                                    required value="{{ $k->hp_karyawan }}">
                                @error('hp_karyawan')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Jenis Kelamin</label>
                                <div class="row">

                                    <div class="col-md-6">
                                        <div class="custom-control custom-radio">
                                            <input class="custom-control-input" type="radio"
                                                id="laki{{ $k->id }}" value="L" name="kelamin_karyawan"
                                                checked {{ $k->kelamin_karyawan == 'L' ? 'checked' : '' }}>
                                            <label for="laki{{ $k->id }}"
                                                class="custom-control-label ">Laki-Laki
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="custom-control custom-radio">
                                            <input class="custom-control-input" type="radio"
                                                id="perempuan{{ $k->id }}" value="P"
                                                name="kelamin_karyawan"
                                                {{ $k->kelamin_karyawan == 'P' ? 'checked' : '' }}>
                                            <label for="perempuan{{ $k->id }}"
                                                class="custom-control-label ">Perempuan
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                @error('kelamin_karyawan')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Alamat Lengkap</label>
                                <textarea name="alamat_karyawan" id="" class="form-control" placeholder="Alamat....">{{ $k->alamat_karyawan }}</textarea>
                                @error('alamat_karyawan')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button class="btn btn-primary "><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {
                $('.myTable').DataTable();
            });

            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Karyawan  dengan Nama ( " + nama +
                        " ) & data yang berkaitan dengan Data tersebut akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-karyawan/" + id;
                    }
                });

            });
        </script>
    </x-slot:foot>
</x-admin.contents>
